/* THIS FILE IS AUTOGENERATED FROM MessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MessageEventBinding_h
#define mozilla_dom_MessageEventBinding_h

#include "EventBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/WindowProxyHolder.h"

namespace mozilla {
namespace dom {

class MessageEvent;
struct MessageEventInitAtoms;
class MessagePort;
struct NativePropertyHooks;
class OwningWindowProxyOrMessagePortOrServiceWorker;
class ProtoAndIfaceCache;
class ServiceWorker;
class WindowProxyOrMessagePortOrServiceWorker;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWindowProxyOrMessagePortOrServiceWorker& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningWindowProxyOrMessagePortOrServiceWorker& aUnion);


class WindowProxyOrMessagePortOrServiceWorker
{
  enum TypeOrUninit
  {
    eUninitialized,
    eWindowProxy,
    eMessagePort,
    eServiceWorker
  };
public:
  enum class Type
  {
    eWindowProxy = TypeOrUninit::eWindowProxy,
    eMessagePort = TypeOrUninit::eMessagePort,
    eServiceWorker = TypeOrUninit::eServiceWorker
  };

private:
  union Value
  {
    UnionMember<mozilla::dom::WindowProxyHolder > mWindowProxy;
    UnionMember<NonNull<mozilla::dom::MessagePort> > mMessagePort;
    UnionMember<NonNull<mozilla::dom::ServiceWorker> > mServiceWorker;

  };

  TypeOrUninit mType;
  Value mValue;

  WindowProxyOrMessagePortOrServiceWorker(const WindowProxyOrMessagePortOrServiceWorker&) = delete;
  WindowProxyOrMessagePortOrServiceWorker& operator=(const WindowProxyOrMessagePortOrServiceWorker&) = delete;
public:
  explicit inline WindowProxyOrMessagePortOrServiceWorker()
    : mType(eUninitialized)
  {
  }

  inline ~WindowProxyOrMessagePortOrServiceWorker()
  {
    Uninit();
  }

  inline mozilla::dom::WindowProxyHolder&
  RawSetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline mozilla::dom::WindowProxyHolder&
  SetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    Uninit();
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline mozilla::dom::WindowProxyHolder&
  GetAsWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline WindowProxyHolder const&
  GetAsWindowProxy() const
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline NonNull<mozilla::dom::MessagePort>&
  RawSetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline NonNull<mozilla::dom::MessagePort>&
  SetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    Uninit();
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline NonNull<mozilla::dom::MessagePort>&
  GetAsMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline mozilla::dom::MessagePort&
  GetAsMessagePort() const
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  RawSetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  SetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    Uninit();
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline mozilla::dom::ServiceWorker&
  GetAsServiceWorker() const
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eWindowProxy: {
        DestroyWindowProxy();
        break;
      }
      case eMessagePort: {
        DestroyMessagePort();
        break;
      }
      case eServiceWorker: {
        DestroyServiceWorker();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    mValue.mWindowProxy.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    mValue.mMessagePort.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    mValue.mServiceWorker.Destroy();
    mType = eUninitialized;
  }
};


class OwningWindowProxyOrMessagePortOrServiceWorker : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningWindowProxyOrMessagePortOrServiceWorker& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eWindowProxy,
    eMessagePort,
    eServiceWorker
  };
public:
  enum class Type
  {
    eWindowProxy = TypeOrUninit::eWindowProxy,
    eMessagePort = TypeOrUninit::eMessagePort,
    eServiceWorker = TypeOrUninit::eServiceWorker
  };

private:
  union Value
  {
    UnionMember<mozilla::dom::WindowProxyHolder > mWindowProxy;
    UnionMember<OwningNonNull<mozilla::dom::MessagePort> > mMessagePort;
    UnionMember<OwningNonNull<mozilla::dom::ServiceWorker> > mServiceWorker;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningWindowProxyOrMessagePortOrServiceWorker()
    : mType(eUninitialized)
  {
  }

  OwningWindowProxyOrMessagePortOrServiceWorker(OwningWindowProxyOrMessagePortOrServiceWorker&& aOther);

  explicit inline OwningWindowProxyOrMessagePortOrServiceWorker(const OwningWindowProxyOrMessagePortOrServiceWorker& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningWindowProxyOrMessagePortOrServiceWorker()
  {
    Uninit();
  }

  mozilla::dom::WindowProxyHolder&
  RawSetAsWindowProxy();

  mozilla::dom::WindowProxyHolder&
  SetAsWindowProxy();

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline mozilla::dom::WindowProxyHolder&
  GetAsWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline mozilla::dom::WindowProxyHolder const &
  GetAsWindowProxy() const
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  OwningNonNull<mozilla::dom::MessagePort>&
  RawSetAsMessagePort();

  OwningNonNull<mozilla::dom::MessagePort>&
  SetAsMessagePort();

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline OwningNonNull<mozilla::dom::MessagePort>&
  GetAsMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline OwningNonNull<mozilla::dom::MessagePort> const &
  GetAsMessagePort() const
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  OwningNonNull<mozilla::dom::ServiceWorker>&
  RawSetAsServiceWorker();

  OwningNonNull<mozilla::dom::ServiceWorker>&
  SetAsServiceWorker();

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline OwningNonNull<mozilla::dom::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline OwningNonNull<mozilla::dom::ServiceWorker> const &
  GetAsServiceWorker() const
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningWindowProxyOrMessagePortOrServiceWorker&
  operator=(OwningWindowProxyOrMessagePortOrServiceWorker&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningWindowProxyOrMessagePortOrServiceWorker&
  operator=(const OwningWindowProxyOrMessagePortOrServiceWorker& aOther);

private:
  bool
  TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyWindowProxy();

  bool
  TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMessagePort();

  bool
  TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyServiceWorker();
};


struct MessageEventInit : public EventInit
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mData;
  MOZ_INIT_OUTSIDE_CTOR nsString mLastEventId;
  MOZ_INIT_OUTSIDE_CTOR nsString mOrigin;
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::dom::MessagePort>> mPorts;
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningWindowProxyOrMessagePortOrServiceWorker > mSource;

  MessageEventInit();

  explicit inline MessageEventInit(const FastDictionaryInitializer& )
    : EventInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MessageEventInit(MessageEventInit&& aOther) = default;

private:
  MessageEventInit(const MessageEventInit&) = delete;
  MessageEventInit& operator=(const MessageEventInit&) = delete;

  static bool
  InitIds(JSContext* cx, MessageEventInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mPorts, "mPorts", aFlags);
    ImplCycleCollectionTraverse(aCallback, mSource, "mSource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mPorts);
    ImplCycleCollectionUnlink(mSource);
  }
};

namespace binding_detail {
struct FastMessageEventInit : public MessageEventInit
{
  inline FastMessageEventInit()
    : MessageEventInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MessageEvent_Binding {

  typedef mozilla::dom::MessageEvent NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::MessageEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedPortsValue(mozilla::dom::MessageEvent* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MessageEvent_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_MessageEventBinding_h
