/* THIS FILE IS AUTOGENERATED FROM AudioNode.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AudioNodeBinding_h
#define mozilla_dom_AudioNodeBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class AudioNode;
struct AudioNodeOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class ChannelCountMode : uint8_t {
  Max,
  Clamped_max,
  Explicit,
  EndGuard_
};

namespace ChannelCountModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ChannelCountMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ChannelCountMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ChannelCountModeValues

bool
ToJSValue(JSContext* aCx, ChannelCountMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ChannelInterpretation : uint8_t {
  Speakers,
  Discrete,
  EndGuard_
};

namespace ChannelInterpretationValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ChannelInterpretation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ChannelInterpretation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ChannelInterpretationValues

bool
ToJSValue(JSContext* aCx, ChannelInterpretation aArgument, JS::MutableHandle<JS::Value> aValue);


struct AudioNodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mChannelCount;
  MOZ_INIT_OUTSIDE_CTOR Optional<ChannelCountMode> mChannelCountMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<ChannelInterpretation> mChannelInterpretation;

  AudioNodeOptions();

  explicit inline AudioNodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioNodeOptions(AudioNodeOptions&& aOther) = default;

  explicit inline AudioNodeOptions(const AudioNodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AudioNodeOptions&
  operator=(const AudioNodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, AudioNodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastAudioNodeOptions : public AudioNodeOptions
{
  inline FastAudioNodeOptions()
    : AudioNodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AudioNode_Binding {

  typedef mozilla::dom::AudioNode NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::AudioNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AudioNode_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_AudioNodeBinding_h
