// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsExtensionsMetrics_h
#define mozilla_GleanToolkitMozappsExtensionsMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace addons {
  /**
   * generated from addons.active_addons
   */

  struct ActiveAddonsObjectItem {
    Maybe<nsCString> id;
    Maybe<bool> blocklisted;
    Maybe<nsCString> description;
    Maybe<nsCString> name;
    Maybe<bool> userDisabled;
    Maybe<bool> appDisabled;
    Maybe<nsCString> version;
    Maybe<int64_t> scope;
    Maybe<nsCString> addonType;
    Maybe<bool> foreignInstall;
    Maybe<bool> hasBinaryComponents;
    Maybe<int64_t> installDay;
    Maybe<int64_t> updateDay;
    Maybe<int64_t> signedState;
    Maybe<nsCString> signedTypes;
    Maybe<bool> isSystem;
    Maybe<bool> isWebExtension;
    Maybe<bool> multiprocessCompatible;
    Maybe<bool> quarantineIgnoredByApp;
    Maybe<bool> quarantineIgnoredByUser;
  };

  using ActiveAddonsObject = nsTArray<ActiveAddonsObjectItem>;
  /**
   * The list of currently enabled addons.
   * 
   * Some of the addon fields are not available during startup. The fields
   * that will always be present are id, version, addonType, updateDay, scope,
   * isSystem, isWebExtension, and multiprocessCompatible. All the other
   * fields become present shortly after the `sessionstore-windows-restored`
   * observer topic is notified.
   * 
   * This metric is an echo of the Legacy Telemetry Environment field
   * addons.activeAddons. Like its counterpart, it will only have data in
   * Firefox Desktop and at times and on platforms where the environment would
   * have values.
   * 
   * NOTE: this metric is available in both `metrics` and `addons` pings. However
   * the `addons` ping is the preferred source of data for add-ons related analyses,
   * whereas the `metrics` ping is better suited for analyses that correlates other
   * metrics with the add-ons listed in the `active_addons` metric.
   */
  constexpr impl::ObjectMetric<ActiveAddonsObject, struct ActiveAddonsObjectTag> active_addons(5906);

  /**
   * generated from addons.active_g_m_plugins
   */

  struct ActiveGMPluginsObjectItem {
    Maybe<nsCString> id;
    Maybe<nsCString> version;
    Maybe<bool> userDisabled;
    Maybe<int64_t> applyBackgroundUpdates;
  };

  using ActiveGMPluginsObject = nsTArray<ActiveGMPluginsObjectItem>;
  /**
   * The list of currently enabled Gecko Media Plugins.
   * 
   * Some of the addon fields are not available during startup. The fields
   * that will always be present are id and version. All the other
   * fields become present shortly after the `sessionstore-windows-restored`
   * observer topic is notified.
   * 
   * This metric is an echo of the Legacy Telemetry Environment field
   * addons.activeGMPlugins. Like its counterpart, it will only have data in
   * Firefox Desktop and at times and on platforms where the environment would
   * have values.
   */
  constexpr impl::ObjectMetric<ActiveGMPluginsObject, struct ActiveGMPluginsObjectTag> active_g_m_plugins(5907);

  /**
   * generated from addons.theme
   */

  struct ThemeObject {
    Maybe<nsCString> id;
    Maybe<bool> blocklisted;
    Maybe<nsCString> description;
    Maybe<nsCString> name;
    Maybe<bool> userDisabled;
    Maybe<bool> appDisabled;
    Maybe<nsCString> version;
    Maybe<int64_t> scope;
    Maybe<bool> foreignInstall;
    Maybe<bool> hasBinaryComponents;
    Maybe<int64_t> installDay;
    Maybe<int64_t> updateDay;
    Maybe<int64_t> signedState;
    Maybe<nsCString> signedTypes;
  };
  /**
   * The currently active theme.
   * 
   * Some of the addon fields are not available during startup. The fields
   * that will always be present are id, version, updateDay, and scope. All
   * the other fields become present shortly after the
   * `sessionstore-windows-restored` observer topic is notified.
   * 
   * This metric is an echo of the Legacy Telemetry Environment field
   * addons.theme. Like its counterpart, it will only have data in Firefox
   * Desktop and at times and on platforms where the environment would have
   * values.
   * 
   * NOTE: this metric is available in both `metrics` and `addons` pings. However
   * the `addons` ping is the preferred source of data for add-ons related analyses,
   * whereas the `metrics` ping is better suited for analyses that correlates other
   * metrics with the add-ons listed in the `theme` metric.
   */
  constexpr impl::ObjectMetric<ThemeObject, struct ThemeObjectTag> theme(5908);
}

template <>
inline void impl::ObjectMetric<addons::ActiveAddonsObject, addons::ActiveAddonsObjectTag>::Set(const addons::ActiveAddonsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.id.isSome()) {
          writer.StringProperty("id", *(aobjItem.id));
        }
        if (aobjItem.blocklisted.isSome()) {
          writer.BoolProperty("blocklisted", *(aobjItem.blocklisted));
        }
        if (aobjItem.description.isSome()) {
          writer.StringProperty("description", *(aobjItem.description));
        }
        if (aobjItem.name.isSome()) {
          writer.StringProperty("name", *(aobjItem.name));
        }
        if (aobjItem.userDisabled.isSome()) {
          writer.BoolProperty("userDisabled", *(aobjItem.userDisabled));
        }
        if (aobjItem.appDisabled.isSome()) {
          writer.BoolProperty("appDisabled", *(aobjItem.appDisabled));
        }
        if (aobjItem.version.isSome()) {
          writer.StringProperty("version", *(aobjItem.version));
        }
        if (aobjItem.scope.isSome()) {
          writer.IntProperty("scope", *(aobjItem.scope));
        }
        if (aobjItem.addonType.isSome()) {
          writer.StringProperty("addonType", *(aobjItem.addonType));
        }
        if (aobjItem.foreignInstall.isSome()) {
          writer.BoolProperty("foreignInstall", *(aobjItem.foreignInstall));
        }
        if (aobjItem.hasBinaryComponents.isSome()) {
          writer.BoolProperty("hasBinaryComponents", *(aobjItem.hasBinaryComponents));
        }
        if (aobjItem.installDay.isSome()) {
          writer.IntProperty("installDay", *(aobjItem.installDay));
        }
        if (aobjItem.updateDay.isSome()) {
          writer.IntProperty("updateDay", *(aobjItem.updateDay));
        }
        if (aobjItem.signedState.isSome()) {
          writer.IntProperty("signedState", *(aobjItem.signedState));
        }
        if (aobjItem.signedTypes.isSome()) {
          writer.StringProperty("signedTypes", *(aobjItem.signedTypes));
        }
        if (aobjItem.isSystem.isSome()) {
          writer.BoolProperty("isSystem", *(aobjItem.isSystem));
        }
        if (aobjItem.isWebExtension.isSome()) {
          writer.BoolProperty("isWebExtension", *(aobjItem.isWebExtension));
        }
        if (aobjItem.multiprocessCompatible.isSome()) {
          writer.BoolProperty("multiprocessCompatible", *(aobjItem.multiprocessCompatible));
        }
        if (aobjItem.quarantineIgnoredByApp.isSome()) {
          writer.BoolProperty("quarantineIgnoredByApp", *(aobjItem.quarantineIgnoredByApp));
        }
        if (aobjItem.quarantineIgnoredByUser.isSome()) {
          writer.BoolProperty("quarantineIgnoredByUser", *(aobjItem.quarantineIgnoredByUser));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<addons::ActiveGMPluginsObject, addons::ActiveGMPluginsObjectTag>::Set(const addons::ActiveGMPluginsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.id.isSome()) {
          writer.StringProperty("id", *(aobjItem.id));
        }
        if (aobjItem.version.isSome()) {
          writer.StringProperty("version", *(aobjItem.version));
        }
        if (aobjItem.userDisabled.isSome()) {
          writer.BoolProperty("userDisabled", *(aobjItem.userDisabled));
        }
        if (aobjItem.applyBackgroundUpdates.isSome()) {
          writer.IntProperty("applyBackgroundUpdates", *(aobjItem.applyBackgroundUpdates));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<addons::ThemeObject, addons::ThemeObjectTag>::Set(const addons::ThemeObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.id.isSome()) {
      writer.StringProperty("id", *(aObj.id));
    }
    if (aObj.blocklisted.isSome()) {
      writer.BoolProperty("blocklisted", *(aObj.blocklisted));
    }
    if (aObj.description.isSome()) {
      writer.StringProperty("description", *(aObj.description));
    }
    if (aObj.name.isSome()) {
      writer.StringProperty("name", *(aObj.name));
    }
    if (aObj.userDisabled.isSome()) {
      writer.BoolProperty("userDisabled", *(aObj.userDisabled));
    }
    if (aObj.appDisabled.isSome()) {
      writer.BoolProperty("appDisabled", *(aObj.appDisabled));
    }
    if (aObj.version.isSome()) {
      writer.StringProperty("version", *(aObj.version));
    }
    if (aObj.scope.isSome()) {
      writer.IntProperty("scope", *(aObj.scope));
    }
    if (aObj.foreignInstall.isSome()) {
      writer.BoolProperty("foreignInstall", *(aObj.foreignInstall));
    }
    if (aObj.hasBinaryComponents.isSome()) {
      writer.BoolProperty("hasBinaryComponents", *(aObj.hasBinaryComponents));
    }
    if (aObj.installDay.isSome()) {
      writer.IntProperty("installDay", *(aObj.installDay));
    }
    if (aObj.updateDay.isSome()) {
      writer.IntProperty("updateDay", *(aObj.updateDay));
    }
    if (aObj.signedState.isSome()) {
      writer.IntProperty("signedState", *(aObj.signedState));
    }
    if (aObj.signedTypes.isSome()) {
      writer.StringProperty("signedTypes", *(aObj.signedTypes));
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace addons_manager {
  /**
   * generated from addons_manager.compatibility_check_enabled
   * Whether application compatibility is enforced for add-ons.
   */
  constexpr impl::BooleanMetric compatibility_check_enabled(5909);

  /**
   * generated from addons_manager.exception
   */

  struct ExceptionObject {
    Maybe<nsCString> module;
    Maybe<nsCString> context;
    Maybe<nsCString> message;
    Maybe<nsCString> file;
    Maybe<int64_t> line;
  };
  /**
   * Most recent exception reported by the Addons Manager this app session.
   * Previously reported in the "main" ping `simpleMeasurements`.
   * ```text
   * {
   *   module: string module name,
   *   context: string context, like the method name,
   *   message: string message of the exception,
   *   file: the file that the exception occured in,
   *   line: the line number the exception was thrown from,
   * }
   * ```
   */
  constexpr impl::ObjectMetric<ExceptionObject, struct ExceptionObjectTag> exception(5910);

  /**
   * generated from addons_manager.install
   */
  struct InstallExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<uint32_t> downloadTime;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> installId;
    mozilla::Maybe<nsCString> installOrigins;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<nsCString> updatedFrom;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (downloadTime) {
        extraKeys.AppendElement()->AssignASCII("download_time");
        extraValues.AppendElement()->AppendInt(downloadTime.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (installId) {
        extraKeys.AppendElement()->AssignASCII("install_id");
        extraValues.EmplaceBack(installId.value());
      }
      if (installOrigins) {
        extraKeys.AppendElement()->AssignASCII("install_origins");
        extraValues.EmplaceBack(installOrigins.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (updatedFrom) {
        extraKeys.AppendElement()->AssignASCII("updated_from");
        extraValues.EmplaceBack(updatedFrom.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded during the install and update flow for
   * extensions and themes.
   */
  constexpr impl::EventMetric<InstallExtra> install(5911);

  /**
   * generated from addons_manager.install_stats
   */
  struct InstallStatsExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<nsCString> hashedAddonId;
    mozilla::Maybe<nsCString> taarBased;
    mozilla::Maybe<nsCString> utmCampaign;
    mozilla::Maybe<nsCString> utmContent;
    mozilla::Maybe<nsCString> utmMedium;
    mozilla::Maybe<nsCString> utmSource;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (hashedAddonId) {
        extraKeys.AppendElement()->AssignASCII("hashed_addon_id");
        extraValues.EmplaceBack(hashedAddonId.value());
      }
      if (taarBased) {
        extraKeys.AppendElement()->AssignASCII("taar_based");
        extraValues.EmplaceBack(taarBased.value());
      }
      if (utmCampaign) {
        extraKeys.AppendElement()->AssignASCII("utm_campaign");
        extraValues.EmplaceBack(utmCampaign.value());
      }
      if (utmContent) {
        extraKeys.AppendElement()->AssignASCII("utm_content");
        extraValues.EmplaceBack(utmContent.value());
      }
      if (utmMedium) {
        extraKeys.AppendElement()->AssignASCII("utm_medium");
        extraValues.EmplaceBack(utmMedium.value());
      }
      if (utmSource) {
        extraKeys.AppendElement()->AssignASCII("utm_source");
        extraValues.EmplaceBack(utmSource.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded at the end of the install flow, but only
   * when the source that originally triggered the add-on installation
   * is "amo", "rtamo" or "disco".
   */
  constexpr impl::EventMetric<InstallStatsExtra> install_stats(5912);

  /**
   * generated from addons_manager.manage
   */
  struct ManageExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<nsCString> blocklistState;
    mozilla::Maybe<nsCString> method;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (blocklistState) {
        extraKeys.AppendElement()->AssignASCII("blocklist_state");
        extraValues.EmplaceBack(blocklistState.value());
      }
      if (method) {
        extraKeys.AppendElement()->AssignASCII("method");
        extraValues.EmplaceBack(method.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This events are recorded when an installed add-ons is being
   * disable/enabled/uninstalled.
   */
  constexpr impl::EventMetric<ManageExtra> manage(5913);

  /**
   * generated from addons_manager.report_suspicious_site
   */
  struct ReportSuspiciousSiteExtra {
    mozilla::Maybe<nsCString> suspiciousSite;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (suspiciousSite) {
        extraKeys.AppendElement()->AssignASCII("suspicious_site");
        extraValues.EmplaceBack(suspiciousSite.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a user clicks "Report Suspicious Site" on the dropdown
   * menu of the third-party xpinstall doorhanger.
   */
  constexpr impl::EventMetric<ReportSuspiciousSiteExtra> report_suspicious_site(5914);

  /**
   * generated from addons_manager.startup_timeline
   */
  enum class StartupTimelineLabel: uint16_t {
    eAmiStartupBegin = 0,
    eAmiStartupEnd = 1,
    eXpiStartupBegin = 2,
    eXpiBootstrapAddonsBegin = 3,
    eXpiBootstrapAddonsEnd = 4,
    eXpiFinaluistartup = 5,
    eXpiStartupEnd = 6,
    e__Other__,
  };
  /**
   * Events on the startup timeline, in millis since process creation.
   * Previously carried in Legacy "main" ping `simpleMeasurements`.
   */
  constexpr impl::Labeled<impl::QuantityMetric, StartupTimelineLabel> startup_timeline(5915);

  /**
   * generated from addons_manager.update
   */
  struct UpdateExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<uint32_t> downloadTime;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> installId;
    mozilla::Maybe<nsCString> installOrigins;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<nsCString> updatedFrom;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (downloadTime) {
        extraKeys.AppendElement()->AssignASCII("download_time");
        extraValues.AppendElement()->AppendInt(downloadTime.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (installId) {
        extraKeys.AppendElement()->AssignASCII("install_id");
        extraValues.EmplaceBack(installId.value());
      }
      if (installOrigins) {
        extraKeys.AppendElement()->AssignASCII("install_origins");
        extraValues.EmplaceBack(installOrigins.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (updatedFrom) {
        extraKeys.AppendElement()->AssignASCII("updated_from");
        extraValues.EmplaceBack(updatedFrom.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded during the install and update flow for
   * extensions and themes.
   */
  constexpr impl::EventMetric<UpdateExtra> update(5916);

  /**
   * generated from addons_manager.xpistates_write_errors
   */
  struct XpistatesWriteErrorsExtra {
    mozilla::Maybe<nsCString> errorType;
    mozilla::Maybe<nsCString> profileState;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorType) {
        extraKeys.AppendElement()->AssignASCII("error_type");
        extraValues.EmplaceBack(errorType.value());
      }
      if (profileState) {
        extraKeys.AppendElement()->AssignASCII("profile_state");
        extraValues.EmplaceBack(profileState.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when saving addonStartup.json.lz4 data back to disk fails.
   */
  constexpr impl::EventMetric<XpistatesWriteErrorsExtra> xpistates_write_errors(5917);
}

template <>
inline void impl::ObjectMetric<addons_manager::ExceptionObject, addons_manager::ExceptionObjectTag>::Set(const addons_manager::ExceptionObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.module.isSome()) {
      writer.StringProperty("module", *(aObj.module));
    }
    if (aObj.context.isSome()) {
      writer.StringProperty("context", *(aObj.context));
    }
    if (aObj.message.isSome()) {
      writer.StringProperty("message", *(aObj.message));
    }
    if (aObj.file.isSome()) {
      writer.StringProperty("file", *(aObj.file));
    }
    if (aObj.line.isSome()) {
      writer.IntProperty("line", *(aObj.line));
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace blocklist {
  /**
   * generated from blocklist.addon_block_change
   */
  struct AddonBlockChangeExtra {
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> blocklistState;
    mozilla::Maybe<nsCString> hoursSince;
    mozilla::Maybe<nsCString> mlbfGeneration;
    mozilla::Maybe<nsCString> mlbfLastTime;
    mozilla::Maybe<nsCString> mlbfSoftblocksGeneration;
    mozilla::Maybe<nsCString> mlbfSoftblocksSource;
    mozilla::Maybe<nsCString> mlbfSource;
    mozilla::Maybe<nsCString> object;
    mozilla::Maybe<nsCString> signedDate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (blocklistState) {
        extraKeys.AppendElement()->AssignASCII("blocklist_state");
        extraValues.EmplaceBack(blocklistState.value());
      }
      if (hoursSince) {
        extraKeys.AppendElement()->AssignASCII("hours_since");
        extraValues.EmplaceBack(hoursSince.value());
      }
      if (mlbfGeneration) {
        extraKeys.AppendElement()->AssignASCII("mlbf_generation");
        extraValues.EmplaceBack(mlbfGeneration.value());
      }
      if (mlbfLastTime) {
        extraKeys.AppendElement()->AssignASCII("mlbf_last_time");
        extraValues.EmplaceBack(mlbfLastTime.value());
      }
      if (mlbfSoftblocksGeneration) {
        extraKeys.AppendElement()->AssignASCII("mlbf_softblocks_generation");
        extraValues.EmplaceBack(mlbfSoftblocksGeneration.value());
      }
      if (mlbfSoftblocksSource) {
        extraKeys.AppendElement()->AssignASCII("mlbf_softblocks_source");
        extraValues.EmplaceBack(mlbfSoftblocksSource.value());
      }
      if (mlbfSource) {
        extraKeys.AppendElement()->AssignASCII("mlbf_source");
        extraValues.EmplaceBack(mlbfSource.value());
      }
      if (object) {
        extraKeys.AppendElement()->AssignASCII("object");
        extraValues.EmplaceBack(object.value());
      }
      if (signedDate) {
        extraKeys.AppendElement()->AssignASCII("signed_date");
        extraValues.EmplaceBack(signedDate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An add-on is blocked, or an installed add-on is unblocked. When an add-on install/update is blocked, its installation is aborted and the add-on is no longer listed in the activeAddons field of TelemetryEnvironment.
   */
  constexpr impl::EventMetric<AddonBlockChangeExtra> addon_block_change(5974);

  /**
   * generated from blocklist.enabled
   * Whether the extension blocklist is enabled.
   * Corresponds to the `extensions.blocklist.enabled` pref.
   */
  constexpr impl::BooleanMetric enabled(5975);

  /**
   * generated from blocklist.last_modified_rs_addons_mblf
   * Keep track of the last time the "addons-bloomfilters" remotesetting blocklist has been successfully updated.
   */
  constexpr impl::DatetimeMetric last_modified_rs_addons_mblf(5976);

  /**
   * generated from blocklist.mlbf_generation_time
   * Keep track of the generation time of the addon blocklist's bloom filter. This marks the point in time until which signed add-ons are recognized by the selected bloom filter from the addons-bloomfilters collection.
   */
  constexpr impl::DatetimeMetric mlbf_generation_time(5977);

  /**
   * generated from blocklist.mlbf_softblocks_generation_time
   * Keep track of the generation time of the addon blocklist's bloom filter. This marks the point in time until which signed add-ons are recognized by the selected bloom filter from the addons-bloomfilters collection.
   */
  constexpr impl::DatetimeMetric mlbf_softblocks_generation_time(5978);

  /**
   * generated from blocklist.mlbf_softblocks_source
   * The source of the RemoteSettings attachment that holds the bloom filter. Possible values are "dump_match", "cache_match", "remote_match","dump_fallback", "cache_fallback", "unknown". "dump_match", "cache_match" and "remote_match" are expected known-good values, and means that the loaded bloomfilter matches the blocklist record in the RemoteSettings collection. The prefix denotes the immediate source of the loaded data: "dump" means packaged with the application, "remote" means a freshly downloaded bloomfilter, "cache" means a previously downloaded bloomfilter. "dump_fallback" and "cache_fallback" means that the last known bloomfilter was used, despite it not matching the latest record in the RemoteSettings collection. In this case the outdated bloomfilter is used as a fallback (e.g. because the latest version cannot be downloaded). "unknown"  means that the bloomfilter cannot be loaded at all. This can happen if the blocklist is disabled via preferences or enterprise policies.
   */
  constexpr impl::StringMetric mlbf_softblocks_source(5979);

  /**
   * generated from blocklist.mlbf_source
   * The source of the RemoteSettings attachment that holds the bloom filter. Possible values are "dump_match", "cache_match", "remote_match","dump_fallback", "cache_fallback", "unknown". "dump_match", "cache_match" and "remote_match" are expected known-good values, and means that the loaded bloomfilter matches the blocklist record in the RemoteSettings collection. The prefix denotes the immediate source of the loaded data: "dump" means packaged with the application, "remote" means a freshly downloaded bloomfilter, "cache" means a previously downloaded bloomfilter. "dump_fallback" and "cache_fallback" means that the last known bloomfilter was used, despite it not matching the latest record in the RemoteSettings collection. In this case the outdated bloomfilter is used as a fallback (e.g. because the latest version cannot be downloaded). "unknown"  means that the bloomfilter cannot be loaded at all. This can happen if the blocklist is disabled via preferences or enterprise policies.
   */
  constexpr impl::StringMetric mlbf_source(5980);

  /**
   * generated from blocklist.mlbf_stash_time_newest
   * Keep track of the timestamp of the most recent stash of the addons blocklist.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_newest(5981);

  /**
   * generated from blocklist.mlbf_stash_time_oldest
   * Keep track of the timestamp of the oldest stash of the addons blocklist.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_oldest(5982);
}

namespace xpi_database {
  /**
   * generated from xpi.database.late_load
   * Stack of XPI Database `asyncLoadDB` call happening while the XPI provider
   * is closing.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::TextMetric late_load(5983);

  /**
   * generated from xpi.database.late_stack
   * Stack of XPI Database `saveChanges` call happening while the XPI provider
   * is closing.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::TextMetric late_stack(5984);

  /**
   * generated from xpi.database.parses
   * How long it took to parse the XPI Database.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::TimingDistributionMetric parses(5985);

  /**
   * generated from xpi.database.rebuilds
   */
  enum class RebuildsLabel: uint16_t {
    eXpidbRebuildreadfailedMs = 0,
    eXpidbRebuildbadjsonMs = 1,
    eXpidbRebuildunreadabledbMs = 2,
    e__Other__,
  };
  /**
   * How long it took to rebuild the XPI Database
   * per reason it was rebuilt.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, RebuildsLabel> rebuilds(5986);

  /**
   * generated from xpi.database.startup_error
   * Reason for XPI Database startup error.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::StringMetric startup_error(5987);

  /**
   * generated from xpi.database.startup_load_reasons
   * List of reasons the XPI Database was updated.
   * Examples include "appChanged", "directoryState".
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::StringListMetric startup_load_reasons(5988);

  /**
   * generated from xpi.database.sync_stack
   * Stack of XPI Database `syncLoadDB` call.
   * Previously reported in "main" ping `simpleMeasurements`.
   */
  constexpr impl::TextMetric sync_stack(5989);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsExtensionsMetrics_h
